/*
 * Decompiled with CFR 0.152.
 */
package xyz.luan.audioplayers.player;

import android.media.AudioManager;
import android.os.Build;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import xyz.luan.audioplayers.AudioContextAndroid;
import xyz.luan.audioplayers.player.LegacyFocusManager;
import xyz.luan.audioplayers.player.ModernFocusManager;
import xyz.luan.audioplayers.player.WrappedPlayer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\b&\u0018\u0000 '2\u00020\u0001:\u0001'B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u001b\u001a\u00020\u000fH$J\b\u0010\u001c\u001a\u00020\nH$J\u0006\u0010!\u001a\u00020\nJ\b\u0010\"\u001a\u00020\nH$J\b\u0010#\u001a\u00020\nH&J\u0010\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020&H\u0004R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR-\u0010\r\u001a\u001d\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\n0\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0015\u001a\u00020\u0016X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001d\u001a\u00020\u001e8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006("}, d2={"Lxyz/luan/audioplayers/player/FocusManager;", "", "<init>", "()V", "player", "Lxyz/luan/audioplayers/player/WrappedPlayer;", "getPlayer", "()Lxyz/luan/audioplayers/player/WrappedPlayer;", "onGranted", "Lkotlin/Function0;", "", "getOnGranted", "()Lkotlin/jvm/functions/Function0;", "onLoss", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "isTransient", "getOnLoss", "()Lkotlin/jvm/functions/Function1;", "context", "Lxyz/luan/audioplayers/AudioContextAndroid;", "getContext", "()Lxyz/luan/audioplayers/AudioContextAndroid;", "setContext", "(Lxyz/luan/audioplayers/AudioContextAndroid;)V", "hasAudioFocusRequest", "updateAudioFocusRequest", "audioManager", "Landroid/media/AudioManager;", "getAudioManager", "()Landroid/media/AudioManager;", "maybeRequestAudioFocus", "requestAudioFocus", "handleStop", "handleFocusResult", "result", "", "Companion", "audioplayers_android_debug"})
public abstract class FocusManager {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract WrappedPlayer getPlayer();

    @NotNull
    public abstract Function0<Unit> getOnGranted();

    @NotNull
    public abstract Function1<Boolean, Unit> getOnLoss();

    @NotNull
    public abstract AudioContextAndroid getContext();

    public abstract void setContext(@NotNull AudioContextAndroid var1);

    protected abstract boolean hasAudioFocusRequest();

    protected abstract void updateAudioFocusRequest();

    @NotNull
    protected final AudioManager getAudioManager() {
        return this.getPlayer().getAudioManager();
    }

    public final void maybeRequestAudioFocus() {
        if (!Intrinsics.areEqual((Object)this.getContext(), (Object)this.getPlayer().getContext())) {
            this.setContext(this.getPlayer().getContext());
            this.updateAudioFocusRequest();
        }
        if (this.hasAudioFocusRequest()) {
            this.requestAudioFocus();
        } else {
            this.getOnGranted().invoke();
        }
    }

    protected abstract void requestAudioFocus();

    public abstract void handleStop();

    protected final void handleFocusResult(int result) {
        switch (result) {
            case 1: {
                this.getOnGranted().invoke();
                break;
            }
            case -2: {
                this.getOnLoss().invoke((Object)true);
                break;
            }
            case -1: {
                this.getOnLoss().invoke((Object)false);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J?\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2!\u0010\u000b\u001a\u001d\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\n0\f\u00a8\u0006\u0011"}, d2={"Lxyz/luan/audioplayers/player/FocusManager$Companion;", "", "<init>", "()V", "create", "Lxyz/luan/audioplayers/player/FocusManager;", "player", "Lxyz/luan/audioplayers/player/WrappedPlayer;", "onGranted", "Lkotlin/Function0;", "", "onLoss", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "isTransient", "audioplayers_android_debug"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FocusManager create(@NotNull WrappedPlayer player, @NotNull Function0<Unit> onGranted, @NotNull Function1<? super Boolean, Unit> onLoss) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter(onGranted, (String)"onGranted");
            Intrinsics.checkNotNullParameter(onLoss, (String)"onLoss");
            return Build.VERSION.SDK_INT >= 26 ? (FocusManager)new ModernFocusManager(player, onGranted, onLoss) : (FocusManager)new LegacyFocusManager(player, onGranted, onLoss);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

