/*
 * Decompiled with CFR 0.152.
 */
package xyz.luan.audioplayers.player;

import android.media.MediaPlayer;
import android.os.Build;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.luan.audioplayers.AudioContextAndroid;
import xyz.luan.audioplayers.player.PlayerWrapper;
import xyz.luan.audioplayers.player.WrappedPlayer;
import xyz.luan.audioplayers.source.Source;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u000f\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ\r\u0010\f\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u000eH\u0016J\b\u0010\u001b\u001a\u00020\u000eH\u0016J\b\u0010\u001c\u001a\u00020\u000eH\u0016J\b\u0010\u001d\u001a\u00020\u000eH\u0016J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\nH\u0016J\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u000eH\u0016J\b\u0010$\u001a\u00020\u000eH\u0016J\b\u0010%\u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lxyz/luan/audioplayers/player/MediaPlayerWrapper;", "Lxyz/luan/audioplayers/player/PlayerWrapper;", "wrappedPlayer", "Lxyz/luan/audioplayers/player/WrappedPlayer;", "<init>", "(Lxyz/luan/audioplayers/player/WrappedPlayer;)V", "mediaPlayer", "Landroid/media/MediaPlayer;", "createMediaPlayer", "getDuration", "", "()Ljava/lang/Integer;", "getCurrentPosition", "setVolume", "", "leftVolume", "", "rightVolume", "setRate", "rate", "setSource", "source", "Lxyz/luan/audioplayers/source/Source;", "setLooping", "looping", "", "start", "pause", "stop", "release", "seekTo", "position", "updateContext", "context", "Lxyz/luan/audioplayers/AudioContextAndroid;", "prepare", "reset", "isLiveStream", "audioplayers_android_debug"})
@SourceDebugExtension(value={"SMAP\nMediaPlayerWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediaPlayerWrapper.kt\nxyz/luan/audioplayers/player/MediaPlayerWrapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1#2:101\n*E\n"})
public final class MediaPlayerWrapper
implements PlayerWrapper {
    @NotNull
    private final WrappedPlayer wrappedPlayer;
    @NotNull
    private final MediaPlayer mediaPlayer;

    public MediaPlayerWrapper(@NotNull WrappedPlayer wrappedPlayer) {
        Intrinsics.checkNotNullParameter((Object)wrappedPlayer, (String)"wrappedPlayer");
        this.wrappedPlayer = wrappedPlayer;
        this.mediaPlayer = this.createMediaPlayer(this.wrappedPlayer);
    }

    private final MediaPlayer createMediaPlayer(WrappedPlayer wrappedPlayer) {
        MediaPlayer mediaPlayer;
        MediaPlayer $this$createMediaPlayer_u24lambda_u240 = mediaPlayer = new MediaPlayer();
        boolean bl = false;
        $this$createMediaPlayer_u24lambda_u240.setOnPreparedListener(arg_0 -> MediaPlayerWrapper.createMediaPlayer$lambda$0$0(wrappedPlayer, arg_0));
        $this$createMediaPlayer_u24lambda_u240.setOnCompletionListener(arg_0 -> MediaPlayerWrapper.createMediaPlayer$lambda$0$1(wrappedPlayer, arg_0));
        $this$createMediaPlayer_u24lambda_u240.setOnSeekCompleteListener(arg_0 -> MediaPlayerWrapper.createMediaPlayer$lambda$0$2(wrappedPlayer, arg_0));
        $this$createMediaPlayer_u24lambda_u240.setOnErrorListener((arg_0, arg_1, arg_2) -> MediaPlayerWrapper.createMediaPlayer$lambda$0$3(wrappedPlayer, arg_0, arg_1, arg_2));
        $this$createMediaPlayer_u24lambda_u240.setOnBufferingUpdateListener((arg_0, arg_1) -> MediaPlayerWrapper.createMediaPlayer$lambda$0$4(wrappedPlayer, arg_0, arg_1));
        MediaPlayer mediaPlayer2 = mediaPlayer;
        wrappedPlayer.getContext().setAttributesOnPlayer(mediaPlayer2);
        return mediaPlayer2;
    }

    @Override
    @Nullable
    public Integer getDuration() {
        Integer n = this.mediaPlayer.getDuration();
        int it = ((Number)n).intValue();
        boolean bl = false;
        return !(it == -1) ? n : null;
    }

    @Override
    @NotNull
    public Integer getCurrentPosition() {
        return this.mediaPlayer.getCurrentPosition();
    }

    @Override
    public void setVolume(float leftVolume, float rightVolume) {
        this.mediaPlayer.setVolume(leftVolume, rightVolume);
    }

    @Override
    public void setRate(float rate) {
        if (Build.VERSION.SDK_INT >= 23) {
            this.mediaPlayer.setPlaybackParams(this.mediaPlayer.getPlaybackParams().setSpeed(rate));
        } else if (rate == 1.0f) {
            this.mediaPlayer.start();
        } else {
            throw new IllegalStateException("Changing the playback rate is only available for Android M/23+ or using LOW_LATENCY mode.".toString());
        }
    }

    @Override
    public void setSource(@NotNull Source source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.reset();
        source.setForMediaPlayer(this.mediaPlayer);
    }

    @Override
    public void setLooping(boolean looping) {
        this.mediaPlayer.setLooping(looping);
    }

    @Override
    public void start() {
        this.setRate(this.wrappedPlayer.getRate());
    }

    @Override
    public void pause() {
        this.mediaPlayer.pause();
    }

    @Override
    public void stop() {
        this.mediaPlayer.stop();
    }

    @Override
    public void release() {
        this.mediaPlayer.reset();
        this.mediaPlayer.release();
    }

    @Override
    public void seekTo(int position) {
        this.mediaPlayer.seekTo(position);
    }

    @Override
    public void updateContext(@NotNull AudioContextAndroid context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.setAttributesOnPlayer(this.mediaPlayer);
        if (context.getStayAwake()) {
            this.mediaPlayer.setWakeMode(this.wrappedPlayer.getApplicationContext(), 1);
        }
    }

    @Override
    public void prepare() {
        this.mediaPlayer.prepareAsync();
    }

    @Override
    public void reset() {
        this.mediaPlayer.reset();
    }

    @Override
    public boolean isLiveStream() {
        Integer duration = this.getDuration();
        return duration == null || duration == 0;
    }

    private static final void createMediaPlayer$lambda$0$0(WrappedPlayer $wrappedPlayer, MediaPlayer it) {
        $wrappedPlayer.onPrepared();
    }

    private static final void createMediaPlayer$lambda$0$1(WrappedPlayer $wrappedPlayer, MediaPlayer it) {
        $wrappedPlayer.onCompletion();
    }

    private static final void createMediaPlayer$lambda$0$2(WrappedPlayer $wrappedPlayer, MediaPlayer it) {
        $wrappedPlayer.onSeekComplete();
    }

    private static final boolean createMediaPlayer$lambda$0$3(WrappedPlayer $wrappedPlayer, MediaPlayer mediaPlayer, int what, int extra) {
        return $wrappedPlayer.onError(what, extra);
    }

    private static final void createMediaPlayer$lambda$0$4(WrappedPlayer $wrappedPlayer, MediaPlayer mediaPlayer, int percent) {
        $wrappedPlayer.onBuffering(percent);
    }
}

