/*
 * Decompiled with CFR 0.152.
 */
package com.it_nomads.fluttersecurestorage;

import androidx.annotation.NonNull;
import java.util.Map;

public class FlutterSecureStorageConfig {
    private static final String DEFAULT_PREF_NAME = "FlutterSecureStorage";
    private static final String DEFAULT_KEY_PREFIX = "VGhpcyBpcyB0aGUgcHJlZml4IGZvciBhIHNlY3VyZSBzdG9yYWdlCg";
    private static final Boolean DEFAULT_DELETE_ON_FAILURE = false;
    private static final Boolean DEFAULT_MIGRATE_ON_ALGORITHM_CHANGE = true;
    private static final Boolean DEFAULT_ENCRYPTED_SHARED_PREFERENCES = false;
    private static final Boolean DEFAULT_ENFORCE_BIOMETRICS = false;
    private static final String DEFAULT_BIOMETRIC_PROMPT_TITLE = "Authenticate to access";
    private static final String DEFAULT_BIOMETRIC_PROMPT_SUBTITLE = "Use biometrics or device credentials";
    private static final String DEFAULT_STORAGE_CIPHER_ALGORITHM = "AES_GCM_NoPadding";
    private static final String DEFAULT_KEY_CIPHER_ALGORITHM = "RSA_ECB_PKCS1Padding";
    public static final String PREF_OPTION_NAME = "sharedPreferencesName";
    public static final String PREF_OPTION_PREFIX = "preferencesKeyPrefix";
    public static final String PREF_OPTION_DELETE_ON_FAILURE = "resetOnError";
    public static final String PREF_OPTION_MIGRATE_ON_ALGORITHM_CHANGE = "migrateOnAlgorithmChange";
    public static final String PREF_OPTION_ENCRYPTED_SHARED_PREFERENCES = "encryptedSharedPreferences";
    public static final String PREF_OPTION_ENFORCE_BIOMETRICS = "enforceBiometrics";
    public static final String PREF_OPTION_BIOMETRIC_PROMPT_TITLE = "prefOptionBiometricPromptTitle";
    public static final String PREF_OPTION_BIOMETRIC_PROMPT_SUBTITLE = "prefOptionBiometricPromptSubtitle";
    public static final String PREF_OPTION_STORAGE_CIPHER_ALGORITHM = "storageCipherAlgorithm";
    public static final String PREF_OPTION_KEY_CIPHER_ALGORITHM = "keyCipherAlgorithm";
    private final String sharedPreferencesName;
    private final String sharedPreferencesKeyPrefix;
    private final boolean deleteOnFailure;
    private final boolean migrateOnAlgorithmChange;
    private final boolean useEncryptedSharedPreferences;
    private final boolean enforceBiometrics;
    private final String biometricPromptTitle;
    private final String biometricPromptSubtitle;
    private final String keyCipherAlgorithm;
    private final String storageCipherAlgorithm;

    public FlutterSecureStorageConfig(Map<String, Object> options) {
        this.sharedPreferencesName = this.getStringOption(options, PREF_OPTION_NAME, DEFAULT_PREF_NAME);
        this.sharedPreferencesKeyPrefix = this.getStringOption(options, PREF_OPTION_PREFIX, DEFAULT_KEY_PREFIX);
        this.deleteOnFailure = this.getBooleanOption(options, PREF_OPTION_DELETE_ON_FAILURE, DEFAULT_DELETE_ON_FAILURE);
        this.migrateOnAlgorithmChange = this.getBooleanOption(options, PREF_OPTION_MIGRATE_ON_ALGORITHM_CHANGE, DEFAULT_MIGRATE_ON_ALGORITHM_CHANGE);
        this.useEncryptedSharedPreferences = this.getBooleanOption(options, PREF_OPTION_ENCRYPTED_SHARED_PREFERENCES, DEFAULT_ENCRYPTED_SHARED_PREFERENCES);
        this.enforceBiometrics = this.getBooleanOption(options, PREF_OPTION_ENFORCE_BIOMETRICS, DEFAULT_ENFORCE_BIOMETRICS);
        this.biometricPromptTitle = this.getStringOption(options, PREF_OPTION_BIOMETRIC_PROMPT_TITLE, DEFAULT_BIOMETRIC_PROMPT_TITLE);
        this.biometricPromptSubtitle = this.getStringOption(options, PREF_OPTION_BIOMETRIC_PROMPT_SUBTITLE, DEFAULT_BIOMETRIC_PROMPT_SUBTITLE);
        this.storageCipherAlgorithm = this.getStringOption(options, PREF_OPTION_STORAGE_CIPHER_ALGORITHM, DEFAULT_STORAGE_CIPHER_ALGORITHM);
        this.keyCipherAlgorithm = this.getStringOption(options, PREF_OPTION_KEY_CIPHER_ALGORITHM, DEFAULT_KEY_CIPHER_ALGORITHM);
    }

    private String getStringOption(Map<String, Object> options, String key, String defaultValue) {
        String strValue;
        Object value;
        if (options.containsKey(key) && (value = options.get(key)) instanceof String && !(strValue = (String)value).isEmpty()) {
            return strValue;
        }
        return defaultValue;
    }

    private boolean getBooleanOption(Map<String, Object> options, String key, boolean defaultValue) {
        Object value = options.get(key);
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return defaultValue;
    }

    public String getSharedPreferencesName() {
        return this.sharedPreferencesName;
    }

    public String getSharedPreferencesKeyPrefix() {
        return this.sharedPreferencesKeyPrefix;
    }

    public boolean shouldDeleteOnFailure() {
        return this.deleteOnFailure;
    }

    public boolean shouldMigrateOnAlgorithmChange() {
        return this.migrateOnAlgorithmChange;
    }

    public boolean isUseEncryptedSharedPreferences() {
        return this.useEncryptedSharedPreferences;
    }

    public boolean getEnforceBiometrics() {
        return this.enforceBiometrics;
    }

    public String getBiometricPromptTitle() {
        return this.biometricPromptTitle;
    }

    public String getPrefOptionBiometricPromptSubtitle() {
        return this.biometricPromptSubtitle;
    }

    public String getPrefOptionStorageCipherAlgorithm() {
        return this.storageCipherAlgorithm;
    }

    public String getPrefOptionKeyCipherAlgorithm() {
        return this.keyCipherAlgorithm;
    }

    @NonNull
    public String toString() {
        return "FlutterSecureStorageConfig{sharedPreferencesName='" + this.sharedPreferencesName + '\'' + ", sharedPreferencesKeyPrefix='" + this.sharedPreferencesKeyPrefix + '\'' + ", deleteOnFailure=" + this.deleteOnFailure + ", migrateOnAlgorithmChange=" + this.migrateOnAlgorithmChange + ", enforceBiometrics=" + this.enforceBiometrics + '}';
    }
}

