/*
 * Decompiled with CFR 0.152.
 */
package com.it_nomads.fluttersecurestorage.ciphers;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Base64;
import com.it_nomads.fluttersecurestorage.ciphers.KeyCipher;
import com.it_nomads.fluttersecurestorage.ciphers.StorageCipher;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class StorageCipherImplementationAES23
implements StorageCipher {
    private static final int keySize = 32;
    private static final int defaultIvSize = 12;
    private static final int AUTHENTICATION_TAG_SIZE = 128;
    private static final String KEY_ALGORITHM = "AES";
    private static final String SHARED_PREFERENCES_NAME = "FlutterSecureKeyStorage";
    private static final String KEYSTORE_IV_NAME = "BVGhpcyBpcyB0aGUga2V5IGZvciBhIHNlY3VyZSBzdG9yYWdlIEFFUyBLZXkK";
    private final Cipher cipher;
    private final SecureRandom secureRandom = new SecureRandom();
    private final Key secretKey;

    public StorageCipherImplementationAES23(Context context, KeyCipher ignoredKeyCipher, Cipher cipher) throws Exception {
        this.secretKey = this.loadOrGenerateApplicationKey(context, cipher);
        this.cipher = this.getCipher();
    }

    private SecretKey loadOrGenerateApplicationKey(Context context, Cipher biometricCipher) throws Exception {
        Cipher cipher;
        Cipher cipher2 = cipher = biometricCipher != null ? biometricCipher : this.getCipher();
        assert (cipher != null);
        SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
        String encryptedAppKeyBase64 = preferences.getString(KEYSTORE_IV_NAME, null);
        if (encryptedAppKeyBase64 != null) {
            byte[] encryptedAppKey = Base64.decode((String)encryptedAppKeyBase64, (int)0);
            byte[] appKey = cipher.doFinal(encryptedAppKey);
            return new SecretKeySpec(appKey, KEY_ALGORITHM);
        }
        byte[] appKey = this.generateIV(32);
        SecretKeySpec secretKey = new SecretKeySpec(appKey, KEY_ALGORITHM);
        byte[] newEncryptedAppKey = cipher.doFinal(appKey);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString(KEYSTORE_IV_NAME, Base64.encodeToString((byte[])newEncryptedAppKey, (int)0));
        editor.apply();
        return secretKey;
    }

    @Override
    public void deleteKey(Context context) {
        SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
        preferences.edit().remove(KEYSTORE_IV_NAME).apply();
    }

    protected Cipher getCipher() throws Exception {
        return Cipher.getInstance("AES/GCM/NoPadding");
    }

    @Override
    public byte[] encrypt(byte[] input) throws Exception {
        byte[] iv = this.generateIV(12);
        GCMParameterSpec spec = new GCMParameterSpec(128, iv);
        this.cipher.init(1, this.secretKey, spec);
        byte[] payload = this.cipher.doFinal(input);
        byte[] combined = new byte[iv.length + payload.length];
        System.arraycopy(iv, 0, combined, 0, iv.length);
        System.arraycopy(payload, 0, combined, iv.length, payload.length);
        return combined;
    }

    @Override
    public byte[] decrypt(byte[] input) throws Exception {
        byte[] iv = new byte[12];
        System.arraycopy(input, 0, iv, 0, iv.length);
        int payloadSize = input.length - 12;
        byte[] payload = new byte[payloadSize];
        System.arraycopy(input, iv.length, payload, 0, payloadSize);
        GCMParameterSpec spec = new GCMParameterSpec(128, iv);
        this.cipher.init(2, this.secretKey, spec);
        return this.cipher.doFinal(payload);
    }

    public byte[] generateIV(int size) {
        byte[] iv = new byte[size];
        this.secureRandom.nextBytes(iv);
        return iv;
    }
}

