/*
 * Decompiled with CFR 0.152.
 */
package com.it_nomads.fluttersecurestorage.crypto;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.security.keystore.KeyGenParameterSpec;
import androidx.annotation.DoNotInline;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.it_nomads.fluttersecurestorage.crypto.MasterKeys;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public final class MasterKey {
    static final String KEYSTORE_PATH_URI = "android-keystore://";
    public static final String DEFAULT_MASTER_KEY_ALIAS = "_androidx_security_master_key_";
    public static final int DEFAULT_AES_GCM_MASTER_KEY_SIZE = 256;
    private static final int DEFAULT_AUTHENTICATION_VALIDITY_DURATION_SECONDS = 300;
    @NonNull
    private final String mKeyAlias;
    @Nullable
    private final KeyGenParameterSpec mKeyGenParameterSpec;

    @SuppressLint(value={"MethodNameUnits"})
    public static int getDefaultAuthenticationValidityDurationSeconds() {
        return 300;
    }

    MasterKey(@NonNull String keyAlias, @Nullable Object keyGenParameterSpec) {
        this.mKeyAlias = keyAlias;
        this.mKeyGenParameterSpec = (KeyGenParameterSpec)keyGenParameterSpec;
    }

    public boolean isKeyStoreBacked() {
        try {
            KeyStore keyStore = KeyStore.getInstance("AndroidKeyStore");
            keyStore.load(null);
            return keyStore.containsAlias(this.mKeyAlias);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ignored) {
            return false;
        }
    }

    public boolean isUserAuthenticationRequired() {
        return this.mKeyGenParameterSpec != null && Api23Impl.isUserAuthenticationRequired(this.mKeyGenParameterSpec);
    }

    @SuppressLint(value={"MethodNameUnits"})
    public int getUserAuthenticationValidityDurationSeconds() {
        return this.mKeyGenParameterSpec == null ? 0 : Api23Impl.getUserAuthenticationValidityDurationSeconds(this.mKeyGenParameterSpec);
    }

    public boolean isStrongBoxBacked() {
        if (Build.VERSION.SDK_INT < 28 || this.mKeyGenParameterSpec == null) {
            return false;
        }
        return Api28Impl.isStrongBoxBacked(this.mKeyGenParameterSpec);
    }

    @NonNull
    public String toString() {
        return "MasterKey{keyAlias=" + this.mKeyAlias + ", isKeyStoreBacked=" + this.isKeyStoreBacked() + "}";
    }

    @NonNull
    String getKeyAlias() {
        return this.mKeyAlias;
    }

    static class Api23Impl {
        private Api23Impl() {
        }

        @DoNotInline
        static boolean isUserAuthenticationRequired(KeyGenParameterSpec keyGenParameterSpec) {
            return keyGenParameterSpec.isUserAuthenticationRequired();
        }

        @DoNotInline
        static int getUserAuthenticationValidityDurationSeconds(KeyGenParameterSpec keyGenParameterSpec) {
            return keyGenParameterSpec.getUserAuthenticationValidityDurationSeconds();
        }
    }

    @RequiresApi(value=28)
    static class Api28Impl {
        private Api28Impl() {
        }

        @DoNotInline
        static boolean isStrongBoxBacked(KeyGenParameterSpec keyGenParameterSpec) {
            return keyGenParameterSpec.isStrongBoxBacked();
        }
    }

    public static final class Builder {
        @NonNull
        final String mKeyAlias;
        @Nullable
        KeyGenParameterSpec mKeyGenParameterSpec;
        @Nullable
        KeyScheme mKeyScheme;
        boolean mAuthenticationRequired;
        int mUserAuthenticationValidityDurationSeconds;
        boolean mRequestStrongBoxBacked;
        final Context mContext;

        public Builder(@NonNull Context context) {
            this(context, MasterKey.DEFAULT_MASTER_KEY_ALIAS);
        }

        public Builder(@NonNull Context context, @NonNull String keyAlias) {
            this.mContext = context.getApplicationContext();
            this.mKeyAlias = keyAlias;
        }

        @NonNull
        public Builder setKeyScheme(@NonNull KeyScheme keyScheme) {
            if (keyScheme == KeyScheme.AES256_GCM) {
                if (this.mKeyGenParameterSpec != null) {
                    throw new IllegalArgumentException("KeyScheme set after setting a KeyGenParamSpec");
                }
            } else {
                throw new IllegalArgumentException("Unsupported scheme: " + (Object)((Object)keyScheme));
            }
            this.mKeyScheme = keyScheme;
            return this;
        }

        @NonNull
        public Builder setUserAuthenticationRequired(boolean authenticationRequired) {
            return this.setUserAuthenticationRequired(authenticationRequired, MasterKey.getDefaultAuthenticationValidityDurationSeconds());
        }

        @NonNull
        public Builder setUserAuthenticationRequired(boolean authenticationRequired, @IntRange(from=1L) int userAuthenticationValidityDurationSeconds) {
            this.mAuthenticationRequired = authenticationRequired;
            this.mUserAuthenticationValidityDurationSeconds = userAuthenticationValidityDurationSeconds;
            return this;
        }

        @NonNull
        public Builder setRequestStrongBoxBacked(boolean requestStrongBoxBacked) {
            this.mRequestStrongBoxBacked = requestStrongBoxBacked;
            return this;
        }

        @NonNull
        public Builder setKeyGenParameterSpec(@NonNull KeyGenParameterSpec keyGenParameterSpec) {
            if (this.mKeyScheme != null) {
                throw new IllegalArgumentException("KeyGenParamSpec set after setting a KeyScheme");
            }
            if (!this.mKeyAlias.equals(Api23Impl.getKeystoreAlias(keyGenParameterSpec))) {
                throw new IllegalArgumentException("KeyGenParamSpec's key alias does not match provided alias (" + this.mKeyAlias + " vs " + Api23Impl.getKeystoreAlias(keyGenParameterSpec));
            }
            this.mKeyGenParameterSpec = keyGenParameterSpec;
            return this;
        }

        @NonNull
        public MasterKey build() throws GeneralSecurityException, IOException {
            return Api23Impl.build(this);
        }

        static class Api23Impl {
            private Api23Impl() {
            }

            @DoNotInline
            static String getKeystoreAlias(KeyGenParameterSpec keyGenParameterSpec) {
                return keyGenParameterSpec.getKeystoreAlias();
            }

            static MasterKey build(Builder builder) throws GeneralSecurityException, IOException {
                if (builder.mKeyScheme == null && builder.mKeyGenParameterSpec == null) {
                    throw new IllegalArgumentException("build() called before setKeyGenParameterSpec or setKeyScheme.");
                }
                if (builder.mKeyScheme == KeyScheme.AES256_GCM) {
                    KeyGenParameterSpec.Builder keyGenBuilder = new KeyGenParameterSpec.Builder(builder.mKeyAlias, 3).setBlockModes(new String[]{"GCM"}).setEncryptionPaddings(new String[]{"NoPadding"}).setKeySize(256);
                    if (builder.mAuthenticationRequired) {
                        keyGenBuilder.setUserAuthenticationRequired(true);
                        if (Build.VERSION.SDK_INT >= 30) {
                            Api30Impl.setUserAuthenticationParameters(keyGenBuilder, builder.mUserAuthenticationValidityDurationSeconds, 3);
                        } else {
                            keyGenBuilder.setUserAuthenticationValidityDurationSeconds(builder.mUserAuthenticationValidityDurationSeconds);
                        }
                    }
                    if (Build.VERSION.SDK_INT >= 28 && builder.mRequestStrongBoxBacked && builder.mContext.getPackageManager().hasSystemFeature("android.hardware.strongbox_keystore")) {
                        Api28Impl.setIsStrongBoxBacked(keyGenBuilder);
                    }
                    builder.mKeyGenParameterSpec = keyGenBuilder.build();
                }
                if (builder.mKeyGenParameterSpec == null) {
                    throw new NullPointerException("KeyGenParameterSpec was null after build() check");
                }
                String keyAlias = MasterKeys.getOrCreate(builder.mKeyGenParameterSpec);
                return new MasterKey(keyAlias, builder.mKeyGenParameterSpec);
            }

            @RequiresApi(value=30)
            static class Api30Impl {
                private Api30Impl() {
                }

                @DoNotInline
                static void setUserAuthenticationParameters(KeyGenParameterSpec.Builder builder, int timeout, int type) {
                    builder.setUserAuthenticationParameters(timeout, type);
                }
            }

            @RequiresApi(value=28)
            static class Api28Impl {
                private Api28Impl() {
                }

                @DoNotInline
                static void setIsStrongBoxBacked(KeyGenParameterSpec.Builder builder) {
                    builder.setIsStrongBoxBacked(true);
                }
            }
        }
    }

    public static enum KeyScheme {
        AES256_GCM;

    }
}

