/*
 * Decompiled with CFR 0.152.
 */
package com.it_nomads.fluttersecurestorage.ciphers;

import android.app.KeyguardManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.security.keystore.KeyGenParameterSpec;
import android.util.Base64;
import android.util.Log;
import com.it_nomads.fluttersecurestorage.FlutterSecureStorageConfig;
import com.it_nomads.fluttersecurestorage.ciphers.KeyCipher;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;

class KeyCipherImplementationAES23
implements KeyCipher {
    private static final String TAG = "AESCipher23";
    private static final String KEYSTORE_PROVIDER_ANDROID = "AndroidKeyStore";
    private static final String SHARED_PREFERENCES_NAME = "FlutterSecureKeyStorage";
    private static final String SHARED_PREFERENCES_KEY = "KeyStoreIV1";
    private static final int IV_SIZE = 16;
    private static final int KEY_SIZE = 256;
    protected final String keyAlias;
    protected final Context context;
    protected final FlutterSecureStorageConfig config;

    public KeyCipherImplementationAES23(Context context, FlutterSecureStorageConfig config) throws Exception {
        this.context = context;
        this.config = config;
        this.keyAlias = this.createKeyAlias(context);
        KeyStore ks = KeyStore.getInstance(KEYSTORE_PROVIDER_ANDROID);
        ks.load(null);
        Key privateKey = ks.getKey(this.keyAlias, null);
        if (privateKey == null) {
            this.generateSymmetricKey();
        }
    }

    @Override
    public byte[] wrap(Key key) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("AES symmetric keys in AndroidKeyStore cannot wrap other keys");
    }

    @Override
    public Key unwrap(byte[] wrappedKey, String algorithm) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("AES symmetric keys in AndroidKeyStore cannot unwrap other keys");
    }

    protected String createKeyAlias(Context context) {
        return context.getPackageName() + ".FlutterSecureStoragePluginKey";
    }

    @Override
    public void deleteKey() throws Exception {
        KeyStore ks = KeyStore.getInstance(KEYSTORE_PROVIDER_ANDROID);
        ks.load(null);
        ks.deleteEntry(this.keyAlias);
        SharedPreferences preferences = this.context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
        preferences.edit().remove(SHARED_PREFERENCES_KEY).apply();
    }

    @Override
    public Cipher getCipher(Context context) throws Exception {
        KeyStore ks = KeyStore.getInstance(KEYSTORE_PROVIDER_ANDROID);
        ks.load(null);
        Key key = ks.getKey(this.keyAlias, null);
        if (key == null) {
            this.generateSymmetricKey();
            key = ks.getKey(this.keyAlias, null);
            return this.getEncryptionCipher(context, key);
        }
        return this.getEncryptionCipher(context, key);
    }

    public Cipher getEncryptionCipher(Context context, Key key) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
        String ivBase64 = preferences.getString(SHARED_PREFERENCES_KEY, null);
        if (ivBase64 != null) {
            byte[] iv = Base64.decode((String)ivBase64, (int)0);
            GCMParameterSpec spec = new GCMParameterSpec(128, iv);
            cipher.init(2, key, spec);
        } else {
            cipher.init(1, key);
            byte[] iv = cipher.getIV();
            SharedPreferences.Editor editor = preferences.edit();
            editor.putString(SHARED_PREFERENCES_KEY, Base64.encodeToString((byte[])iv, (int)0));
            editor.apply();
        }
        return cipher;
    }

    protected boolean isStrongBoxAvailable() {
        if (Build.VERSION.SDK_INT < 28) {
            return false;
        }
        return this.context.getPackageManager().hasSystemFeature("android.hardware.strongbox_keystore");
    }

    protected boolean isDeviceSecure() {
        KeyguardManager keyguardManager = (KeyguardManager)this.context.getSystemService("keyguard");
        return keyguardManager != null && keyguardManager.isDeviceSecure();
    }

    public void generateSymmetricKey() throws Exception {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES", KEYSTORE_PROVIDER_ANDROID);
        boolean deviceHasSecurity = this.isDeviceSecure();
        boolean enforceBiometrics = this.config.getEnforceBiometrics();
        if (enforceBiometrics && !deviceHasSecurity) {
            throw new Exception("BIOMETRIC_UNAVAILABLE: Biometric enforcement enabled but device has no PIN, pattern, password, or biometric enrolled. Cannot generate secure key.");
        }
        if (!deviceHasSecurity) {
            Log.w((String)TAG, (String)"Device has no PIN/biometric security. Generating key without user authentication requirement (enforceBiometrics=false).");
        }
        KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder(this.keyAlias, 3).setBlockModes(new String[]{"GCM"}).setEncryptionPaddings(new String[]{"NoPadding"}).setKeySize(256);
        if (deviceHasSecurity) {
            builder.setUserAuthenticationRequired(true);
            if (Build.VERSION.SDK_INT >= 30) {
                builder.setUserAuthenticationParameters(0, 3);
            } else {
                this.configureLegacyAuth(builder);
            }
            builder.setInvalidatedByBiometricEnrollment(true);
        } else {
            builder.setUserAuthenticationRequired(false);
        }
        if (Build.VERSION.SDK_INT >= 28) {
            builder.setUnlockedDeviceRequired(true);
            if (this.isStrongBoxAvailable()) {
                builder.setIsStrongBoxBacked(true);
                Log.d((String)TAG, (String)"StrongBox is available and enabled for biometric key");
            } else {
                Log.w((String)TAG, (String)"StrongBox requested but not available on this device. Using standard TEE.");
            }
        }
        try {
            keyGenerator.init((AlgorithmParameterSpec)builder.build());
            keyGenerator.generateKey();
        }
        catch (Exception e) {
            if (Build.VERSION.SDK_INT >= 28 && this.isStrongBoxAvailable()) {
                Log.w((String)TAG, (String)" Key generation failed with StrongBox. Retrying without StrongBox.", (Throwable)e);
                builder = new KeyGenParameterSpec.Builder(this.keyAlias, 3).setBlockModes(new String[]{"GCM"}).setEncryptionPaddings(new String[]{"NoPadding"}).setKeySize(256).setUnlockedDeviceRequired(true);
                if (deviceHasSecurity) {
                    builder.setUserAuthenticationRequired(true);
                    if (Build.VERSION.SDK_INT >= 30) {
                        builder.setUserAuthenticationParameters(0, 3);
                    } else {
                        this.configureLegacyAuth(builder);
                    }
                    builder.setInvalidatedByBiometricEnrollment(true);
                }
                keyGenerator.init((AlgorithmParameterSpec)builder.build());
                keyGenerator.generateKey();
                Log.d((String)TAG, (String)"Key generation succeeded without StrongBox");
            }
            throw e;
        }
    }

    private void configureLegacyAuth(KeyGenParameterSpec.Builder builder) {
        builder.setUserAuthenticationValidityDurationSeconds(-1);
    }
}

