/*
 * Decompiled with CFR 0.152.
 */
package com.it_nomads.fluttersecurestorage.ciphers;

import com.it_nomads.fluttersecurestorage.ciphers.KeyCipherFunction;
import com.it_nomads.fluttersecurestorage.ciphers.KeyCipherImplementationAES23;
import com.it_nomads.fluttersecurestorage.ciphers.KeyCipherImplementationRSA18;
import com.it_nomads.fluttersecurestorage.ciphers.KeyCipherImplementationRSAOAEP;

enum KeyCipherAlgorithm {
    RSA_ECB_PKCS1Padding(KeyCipherImplementationRSA18::new, 1),
    RSA_ECB_OAEPwithSHA_256andMGF1Padding(KeyCipherImplementationRSAOAEP::new, 23),
    AES_GCM_NoPadding(KeyCipherImplementationAES23::new, 23);

    final KeyCipherFunction keyCipher;
    final int minVersionCode;

    private KeyCipherAlgorithm(KeyCipherFunction keyCipher, int minVersionCode) {
        this.keyCipher = keyCipher;
        this.minVersionCode = minVersionCode;
    }

    public static KeyCipherAlgorithm fromString(String name) {
        if ("AES_GCM_NoPadding_BIOMETRIC".equals(name)) {
            return AES_GCM_NoPadding;
        }
        return KeyCipherAlgorithm.valueOf(name);
    }
}

