/*
 * Decompiled with CFR 0.152.
 */
package com.it_nomads.fluttersecurestorage.ciphers;

import android.content.Context;
import android.security.keystore.KeyGenParameterSpec;
import androidx.annotation.RequiresApi;
import com.it_nomads.fluttersecurestorage.FlutterSecureStorageConfig;
import com.it_nomads.fluttersecurestorage.ciphers.KeyCipherImplementationRSA18;
import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.util.Calendar;
import javax.crypto.Cipher;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import javax.security.auth.x500.X500Principal;

class KeyCipherImplementationRSAOAEP
extends KeyCipherImplementationRSA18 {
    public KeyCipherImplementationRSAOAEP(Context context, FlutterSecureStorageConfig config) throws Exception {
        super(context, config);
    }

    @Override
    protected String createKeyAlias() {
        return this.context.getPackageName() + ".FlutterSecureStoragePluginKeyOAEP";
    }

    @Override
    @RequiresApi(api=23)
    protected AlgorithmParameterSpec makeAlgorithmParameterSpec(Context context, Calendar start, Calendar end) {
        KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder(this.keyAlias, 3).setCertificateSubject(new X500Principal("CN=" + this.keyAlias)).setDigests(new String[]{"SHA-256"}).setBlockModes(new String[]{"ECB"}).setEncryptionPaddings(new String[]{"OAEPPadding"}).setCertificateSerialNumber(BigInteger.valueOf(1L)).setCertificateNotBefore(start.getTime()).setCertificateNotAfter(end.getTime());
        return builder.build();
    }

    @Override
    protected Cipher getRSACipher() throws Exception {
        return Cipher.getInstance("RSA/ECB/OAEPPadding", "AndroidKeyStoreBCWorkaround");
    }

    @Override
    protected AlgorithmParameterSpec getAlgorithmParameterSpec() {
        return new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA1, PSource.PSpecified.DEFAULT);
    }
}

