/*
 * Decompiled with CFR 0.152.
 */
package com.it_nomads.fluttersecurestorage.ciphers;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import com.it_nomads.fluttersecurestorage.FlutterSecureStorageConfig;
import com.it_nomads.fluttersecurestorage.ciphers.KeyCipher;
import com.it_nomads.fluttersecurestorage.ciphers.KeyCipherAlgorithm;
import com.it_nomads.fluttersecurestorage.ciphers.KeyCipherImplementationAES23;
import com.it_nomads.fluttersecurestorage.ciphers.StorageCipher;
import com.it_nomads.fluttersecurestorage.ciphers.StorageCipherAlgorithm;
import com.it_nomads.fluttersecurestorage.ciphers.StorageCipherImplementationAES23;
import com.it_nomads.fluttersecurestorage.ciphers.StorageCipherImplementationGCM;
import javax.crypto.Cipher;

public class StorageCipherFactory {
    private static final String ELEMENT_PREFERENCES_ALGORITHM_PREFIX = "FlutterSecureSAlgorithm";
    private static final String ELEMENT_PREFERENCES_ALGORITHM_KEY = "FlutterSecureSAlgorithmKey";
    private static final String ELEMENT_PREFERENCES_ALGORITHM_STORAGE = "FlutterSecureSAlgorithmStorage";
    private static final KeyCipherAlgorithm DEFAULT_KEY_ALGORITHM = KeyCipherAlgorithm.RSA_ECB_PKCS1Padding;
    private static final StorageCipherAlgorithm DEFAULT_STORAGE_ALGORITHM = StorageCipherAlgorithm.AES_CBC_PKCS7Padding;
    private final KeyCipherAlgorithm savedKeyAlgorithm;
    private final StorageCipherAlgorithm savedStorageAlgorithm;
    private final KeyCipherAlgorithm currentKeyAlgorithm;
    private final StorageCipherAlgorithm currentStorageAlgorithm;
    private final FlutterSecureStorageConfig config;

    public StorageCipherFactory(SharedPreferences configSource, String keyCipherAlgorithm, String storageCipherAlgorithm, FlutterSecureStorageConfig config) {
        this.config = config;
        String savedKeyCipherAlgorithm = configSource.getString(ELEMENT_PREFERENCES_ALGORITHM_KEY, null);
        String savedStorageCipherAlgorithm = configSource.getString(ELEMENT_PREFERENCES_ALGORITHM_STORAGE, null);
        if (savedKeyCipherAlgorithm == null || savedStorageCipherAlgorithm == null) {
            this.savedKeyAlgorithm = DEFAULT_KEY_ALGORITHM;
            this.savedStorageAlgorithm = DEFAULT_STORAGE_ALGORITHM;
        } else {
            this.savedKeyAlgorithm = KeyCipherAlgorithm.fromString(savedKeyCipherAlgorithm);
            this.savedStorageAlgorithm = StorageCipherAlgorithm.fromString(savedStorageCipherAlgorithm);
        }
        StorageCipherAlgorithm currentStorageAlgorithmTmp = StorageCipherAlgorithm.fromString(storageCipherAlgorithm);
        this.currentStorageAlgorithm = currentStorageAlgorithmTmp.minVersionCode <= Build.VERSION.SDK_INT ? currentStorageAlgorithmTmp : DEFAULT_STORAGE_ALGORITHM;
        KeyCipherAlgorithm currentKeyAlgorithmTmp = KeyCipherAlgorithm.fromString(keyCipherAlgorithm);
        KeyCipherAlgorithm keyCipherAlgorithm2 = this.currentKeyAlgorithm = currentKeyAlgorithmTmp.minVersionCode <= Build.VERSION.SDK_INT ? currentKeyAlgorithmTmp : DEFAULT_KEY_ALGORITHM;
        if (savedKeyCipherAlgorithm == null || savedStorageCipherAlgorithm == null) {
            SharedPreferences.Editor source = configSource.edit();
            this.storeCurrentAlgorithms(source);
            source.apply();
        }
    }

    public boolean requiresReEncryption() {
        return this.savedKeyAlgorithm != this.currentKeyAlgorithm || this.savedStorageAlgorithm != this.currentStorageAlgorithm;
    }

    public boolean changedKeyAlgorithm() {
        return this.savedKeyAlgorithm != this.currentKeyAlgorithm;
    }

    public StorageCipher getSavedStorageCipher(Context context, Cipher cipher) throws Exception {
        KeyCipher keyCipher = this.savedKeyAlgorithm.keyCipher.apply(context, this.config);
        return this.createStorageCipher(context, keyCipher, cipher, this.savedStorageAlgorithm);
    }

    public StorageCipher getCurrentStorageCipher(Context context, Cipher cipher) throws Exception {
        KeyCipher keyCipher = this.currentKeyAlgorithm.keyCipher.apply(context, this.config);
        return this.createStorageCipher(context, keyCipher, cipher, this.currentStorageAlgorithm);
    }

    private StorageCipher createStorageCipher(Context context, KeyCipher keyCipher, Cipher cipher, StorageCipherAlgorithm algorithm) throws Exception {
        if (algorithm == StorageCipherAlgorithm.AES_GCM_NoPadding) {
            if (this.isKeyStoreKeyCipher(keyCipher)) {
                return new StorageCipherImplementationAES23(context, keyCipher, cipher);
            }
            return new StorageCipherImplementationGCM(context, keyCipher, cipher);
        }
        if (algorithm.storageCipher == null) {
            throw new Exception("No implementation available for algorithm: " + algorithm.name());
        }
        return algorithm.storageCipher.apply(context, keyCipher, cipher);
    }

    private boolean isKeyStoreKeyCipher(KeyCipher keyCipher) {
        return keyCipher instanceof KeyCipherImplementationAES23;
    }

    public KeyCipher getCurrentKeyCipher(Context context) throws Exception {
        return this.currentKeyAlgorithm.keyCipher.apply(context, this.config);
    }

    public KeyCipher getSavedKeyCipher(Context context) throws Exception {
        return this.savedKeyAlgorithm.keyCipher.apply(context, this.config);
    }

    public void storeCurrentAlgorithms(SharedPreferences.Editor editor) {
        editor.putString(ELEMENT_PREFERENCES_ALGORITHM_KEY, this.currentKeyAlgorithm.name());
        editor.putString(ELEMENT_PREFERENCES_ALGORITHM_STORAGE, this.currentStorageAlgorithm.name());
    }
}

