/*
 * Decompiled with CFR 0.152.
 */
package com.it_nomads.fluttersecurestorage.ciphers;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Base64;
import com.it_nomads.fluttersecurestorage.ciphers.KeyCipher;
import com.it_nomads.fluttersecurestorage.ciphers.StorageCipher;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class StorageCipherImplementationAES18
implements StorageCipher {
    private static final int keySize = 16;
    private static final String KEY_ALGORITHM = "AES";
    private static final String SHARED_PREFERENCES_NAME = "FlutterSecureKeyStorage";
    private static final String SHARED_PREFERENCES_KEY = "VGhpcyBpcyB0aGUga2V5IGZvciBhIHNlY3VyZSBzdG9yYWdlIEFFUyBLZXkK";
    private final Cipher cipher;
    private final SecureRandom secureRandom = new SecureRandom();
    private final Key secretKey;

    public StorageCipherImplementationAES18(Context context, KeyCipher rsaCipher, Cipher ignoredStorageCipher) throws Exception {
        SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
        SharedPreferences.Editor editor = preferences.edit();
        String aesKey = preferences.getString(SHARED_PREFERENCES_KEY, null);
        this.cipher = this.getCipher();
        if (aesKey != null) {
            byte[] encrypted = Base64.decode((String)aesKey, (int)0);
            this.secretKey = rsaCipher.unwrap(encrypted, KEY_ALGORITHM);
            return;
        }
        byte[] key = new byte[16];
        this.secureRandom.nextBytes(key);
        this.secretKey = new SecretKeySpec(key, KEY_ALGORITHM);
        byte[] encryptedKey = rsaCipher.wrap(this.secretKey);
        editor.putString(SHARED_PREFERENCES_KEY, Base64.encodeToString((byte[])encryptedKey, (int)0));
        editor.apply();
    }

    @Override
    public void deleteKey(Context context) {
        SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
        preferences.edit().remove(SHARED_PREFERENCES_KEY).apply();
    }

    protected Cipher getCipher() throws Exception {
        return Cipher.getInstance("AES/CBC/PKCS7Padding");
    }

    @Override
    public byte[] encrypt(byte[] input) throws Exception {
        byte[] iv = new byte[this.getIvSize()];
        this.secureRandom.nextBytes(iv);
        AlgorithmParameterSpec ivParameterSpec = this.getParameterSpec(iv);
        this.cipher.init(1, this.secretKey, ivParameterSpec);
        byte[] payload = this.cipher.doFinal(input);
        byte[] combined = new byte[iv.length + payload.length];
        System.arraycopy(iv, 0, combined, 0, iv.length);
        System.arraycopy(payload, 0, combined, iv.length, payload.length);
        return combined;
    }

    @Override
    public byte[] decrypt(byte[] input) throws Exception {
        byte[] iv = new byte[this.getIvSize()];
        System.arraycopy(input, 0, iv, 0, iv.length);
        AlgorithmParameterSpec ivParameterSpec = this.getParameterSpec(iv);
        int payloadSize = input.length - this.getIvSize();
        byte[] payload = new byte[payloadSize];
        System.arraycopy(input, iv.length, payload, 0, payloadSize);
        this.cipher.init(2, this.secretKey, ivParameterSpec);
        return this.cipher.doFinal(payload);
    }

    protected int getIvSize() {
        return 16;
    }

    protected AlgorithmParameterSpec getParameterSpec(byte[] iv) {
        return new IvParameterSpec(iv);
    }
}

