/*
 * Decompiled with CFR 0.152.
 */
package com.baseflow.geocoding;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.baseflow.geocoding.Geocoding;
import com.baseflow.geocoding.MethodCallHandlerImpl;
import io.flutter.embedding.engine.plugins.FlutterPlugin;

public final class GeocodingPlugin
implements FlutterPlugin {
    private static final String TAG = "GeocodingPlugin";
    @Nullable
    private MethodCallHandlerImpl methodCallHandler;
    @Nullable
    private Geocoding geocoding;

    public void onAttachedToEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        this.geocoding = new Geocoding(binding.getApplicationContext());
        this.methodCallHandler = new MethodCallHandlerImpl(this.geocoding);
        this.methodCallHandler.startListening(binding.getBinaryMessenger());
    }

    public void onDetachedFromEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        if (this.methodCallHandler == null) {
            Log.wtf((String)TAG, (String)"Already detached from the engine.");
            return;
        }
        this.methodCallHandler.stopListening();
        this.methodCallHandler = null;
        this.geocoding = null;
    }
}

