/*
 * Decompiled with CFR 0.152.
 */
package com.tekartik.sqflite;

import android.database.Cursor;
import android.os.Build;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.tekartik.sqflite.dev.Debug;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class Utils {
    public static List<Object> cursorRowToList(Cursor cursor, int length) {
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            Object value = Utils.cursorValue(cursor, i);
            if (Debug.EXTRA_LOGV) {
                String type = Utils.getString(value);
                Log.d((String)"Sqflite", (String)("column " + i + " " + cursor.getType(i) + ": " + value + (type == null ? "" : " (" + type + ")")));
            }
            list.add(value);
        }
        return list;
    }

    @Nullable
    private static String getString(Object value) {
        String type = null;
        if (value != null) {
            if (value.getClass().isArray()) {
                try {
                    type = "array(" + Objects.requireNonNull(value.getClass().getComponentType()).getName() + ")";
                }
                catch (Exception e) {
                    type = "array";
                }
            } else {
                type = value.getClass().getName();
            }
        }
        return type;
    }

    public static Object cursorValue(Cursor cursor, int index) {
        switch (cursor.getType(index)) {
            case 0: {
                return null;
            }
            case 1: {
                return cursor.getLong(index);
            }
            case 2: {
                return cursor.getDouble(index);
            }
            case 3: {
                return cursor.getString(index);
            }
            case 4: {
                return cursor.getBlob(index);
            }
        }
        return null;
    }

    static Locale localeForLanguageTag(String localeString) {
        if (Build.VERSION.SDK_INT >= 21) {
            return Utils.localeForLanguageTag21(localeString);
        }
        return Utils.localeForLanguageTagPre21(localeString);
    }

    @RequiresApi(api=21)
    static Locale localeForLanguageTag21(String localeString) {
        return Locale.forLanguageTag(localeString);
    }

    static Locale localeForLanguageTagPre21(String localeString) {
        String[] parts = localeString.split("-");
        String language = "";
        String country = "";
        String variant = "";
        if (parts.length > 0) {
            language = parts[0];
            if (parts.length > 1) {
                country = parts[1];
                if (parts.length > 2) {
                    variant = parts[parts.length - 1];
                }
            }
        }
        return Utils.localOf(language, country, variant);
    }

    static Locale localOf(String language, String country, String variant) {
        if (Build.VERSION.SDK_INT >= 36) {
            return Locale.of(language, country, variant);
        }
        Locale locale = new Locale(language, country, variant);
        return locale;
    }

    public static long getThreadId(Thread thread) {
        if (Build.VERSION.SDK_INT >= 36) {
            return thread.threadId();
        }
        long id = thread.getId();
        return id;
    }
}

